###############################################################################
#
#   CORA v4.2.0
#
###############################################################################
#
###############################################################################
#
#   Global Parameters
#
###############################################################################
BEGIN GLOBAL_PARAMETERS
  DES_MOD             Droptest and CAE-Droptest        ; Header of the evaluation
  DES_GLO             CORA sample data set loadcase 02 ; Sub-header of the evaluation
#
# Global settings to define the interval of evaluation
  A_THRES             0.030                 ; Threshold to set the start of the interval of evaluation [0,...,1]
  B_THRES             0.075                 ; Threshold to set the end of the interval of evaluation [0,...,1]
  A_EVAL              0.010                 ; Extension of the interval of evaluation [0,...,1]
  B_DELTA_END         0.200                 ; Additional parameter to shorten the interval of evaluation (width of the corridor: A_DELTA_END*Y_NORM) 0 = disabled
  T_MIN/T_MAX         automatic automatic   ; Manually defined start (time) and end (time) of the interval of evaluation (automatic = calculated for each channel)
#
# Global settings of the corridor method
  K                   2                     ; Transition between ratings of 1 and 0 of the corridor method [-] (1 = linear, 2 = quadratic ...)
  G_1                 0.50                  ; Weighting factor of the corridor method [-]
  a_0/b_0             0.05     0.50         ; Width of the inner and outer corridor [-]
  a_sigma/b_sigma     0        0            ; Multiples of the standard deviation to widen the inner and outer corridor [-]
# Global settings of the cross correlation method
  D_MIN               0.01                  ; delta_min as share of the interval of evaluation [0,...,1]
  D_MAX               0.12                  ; delta_max as share of the interval of evaluation [0,...,1]
  INT_MIN             0.80                  ; Minimum overlap of the interval [0,...,1]
  K_V                 10                    ; Transition between ratings of 1 and 0 of the progression rating [-] (1 = linear, 2 = quadratic ...)
  K_G                 1                     ; Transition between ratings of 1 and 0 of the size rating [-] (1 = linear, 2 = quadratic ...)
  K_P                 1                     ; Transition between ratings of 1 and 0 of the phase shift rating [-] (1 = linear, 2 = quadratic ...)
  G_V                 0.50                  ; Weighting factors of the progression rating [-]
  G_G                 0.25                  ; Weighting factors of the size rating [-]
  G_P                 0.25                  ; Weighting factors of the phase shift rating [-]
  G_2                 0.50                  ; Weighting factors of the cross correlation method [-]
# Normalisation of the the weighting factors
  WF_NORM             YES                   ; Normalisation of the weighting factors [YES/NO]?
# Signal settings
  ISONAME_1-2/11-12   YES YES               ; Consideration of the position 1/2 (test object, seating position) and 11/12 (fine location 3 - dummy) of the ISO code [YES/NO]
  MIN_NORM            0.00                  ; Threshold (as fraction of the global absolute maximum amplitude) to start special treatment of secondary axis [0,...,1]
  Y_NORM              extremum              ; Type of calculation of Y_NORM (extremum or value)
#
# Format settings of the html report
  OUTPUT_FORMAT       Hypergraph            ; Export format (LSPOST, PAMVIEW or Hypergraph)
# Layout of the html report
  FONT_SMALL          12                    ; Size of the small font
  FONT_LARGE          14                    ; Size of the large font
  PreT_LC/PostT_LC    -1  -1                ; Expansion of the plotted interval of the curves (-1: complete curve)
## Output
EXPORT_CURVES         YES                   ; output of curves 
##
END GLOBAL_PARAMETERS
#
###############################################################################
#
#  Loadcase
#  x = use global settings
#
###############################################################################
BEGIN LOADCASE
  NAM_LC              Evaluation of CAE_Droptest_01    ; Header of the loadcase
  DES_LC              Loadcase 02                      ; Sub-header of the loadcase
  WF_LC               1                                ; Weighting factor of the loadcase
  METHOD              cora                             ; Type of evaluation [cora/ISO9790]
#
# Layout of the html report
  PreT_LC             x                                ; Expansion of the plotted interval of the curves (pre)
  PostT_LC            x                                ; Expansion of the plotted interval of the curves (post)
#
  BEGIN DATAFILES
#   Name                                            timeshift  unit    g   
#   Reference                                       
    ../../data/loadcase_02/iso/droptest_01.iso      0.0        m-Kg-s  NO  
    ../../data/loadcase_02/iso/droptest_02.iso      0.0        m-Kg-s  NO  
#   Simulation                                                 
    ../../data/loadcase_02/iso/cae_droptest_01.iso  0.0        m-Kg-s  NO  
  END DATAFILES
  BEGIN SIGNALS
#   Channels
#   Name              WF  Y_norm     t_min     t_max     g_V  g_G  g_P  g1  g2  a_0  b_0   a_t       a_sigma  b_sigma  D_min  D_max  Filter
    00SENS010000ACZC  1   extremum   x         x         x    x    x    x   x   x    x     NOTSPEC   x        x        x      x      0
    00SENS010000VEZC  1   extremum   x         x         x    x    x    x   x   x    x     NOTSPEC   x        x        x      x      0
  END SIGNALS
END LOADCASE
#
#
BEGIN LOADCASE
  NAM_LC              Evaluation of CAE_Droptest_02    ; Header of the loadcase
  DES_LC              Loadcase 02                      ; Sub-header of the loadcase
  WF_LC               1                                ; Weighting factor of the loadcase
  METHOD              cora                             ; Type of evaluation [cora/ISO9790]
#
# Layout of the html report
  PreT_LC             x                                ; Expansion of the plotted interval of the curves (pre)
  PostT_LC            x                                ; Expansion of the plotted interval of the curves (post)
#
  BEGIN DATAFILES
#   Name                                               timeshift  unit    g   
#   Reference                                          
    ../../data/loadcase_02/xydata/droptest_01.dat      0.0        m-Kg-s  NO  
    ../../data/loadcase_02/xydata/droptest_02.dat      0.0        m-Kg-s  NO  
#   Simulation                                                    
    ../../data/loadcase_02/xydata/cae_droptest_02.dat  0.0        m-Kg-s  NO  
  END DATAFILES
  BEGIN SIGNALS
#   Channels
#   Name              WF  Y_norm     t_min     t_max     g_V  g_G  g_P  g1  g2  a_0  b_0   a_t       a_sigma  b_sigma  D_min  D_max  Filter
    00SENS010000ACZC  1   extremum   x         x         x    x    x    x   x   x    x     NOTSPEC   x        x        x      x      0
    00SENS010000VEZC  1   extremum   x         x         x    x    x    x   x   x    x     NOTSPEC   x        x        x      x      0
  END SIGNALS
END LOADCASE
#
