##   <<<<<<<<< CORA 4.2.0 >>>>>>>
##
##   Example for the ISO18571 rating calculation with the example date from the annex A of the ISO
##            
##
## Globale Parameter
##
BEGIN GLOBAL_PARAMETERS
DES_MOD       ISO18571              ; Modellbezeichnung
DES_GLO       Examples from Annex A ; Evaluationsbasis
##
## Globale Einstellungen fr das Bewertungsintervall
A_THRES       0.030                 ; Schwellwert fuer die automatische Festlegung des Beginns des Evaluierungsintervalls [0,...,1]
B_THRES       0.075                 ; Schwellwert fuer die automatische Festlegung des Endes des Evaluierungsintervalls [0,...,1]
A_EVAL        0.010                 ; Vor- und Nachlauf fuer die automatische Festlegung des Evaluierungsintervalls in [0,...,1]
B_DELTA_END   0.200                 ; Parameter, um das Evaluierungsintervall zu kuerzen, Korridorbreite: A_DELTA_END*Y_NORM, 0 = deaktiviert
T_MIN/T_MAX   automatic automatic   ; length of time intervall (automatic = calculate a range for each channel)
##
## global parameters corridor correlation
K                2                  ; Exponent factor for calculating the corridor rating [-]
G_1              0.4                ; Weighting factor of the corridor rating [-]
a_0/b_0          0.05  0.50         ; inner and outer corridor width [-]
a_sigma/b_sigma  0     0            ; Faktor der Standardabweichung zur Skalierung des inneren und aeusseren Korridors [-]
## global parameters cross correlation
D_MIN         0.0                   ; inner corridor of phase shift in cross-correlation method [0,...,1] ( NOT USED for ISO_18571 )
D_MAX         0.0                   ; outer corridor of phase shift in cross-correlation method [0,...,1] ( NOT USED for ISO_18571 )
INT_MIN       0.80                  ; 1.0 - Maximum allowable percentage of time shift 
K_V           1                     ; Exponent factor for calculating the slope score [-]
K_G           1                     ; Exponent factor for calculating the magnitude score [-]
K_P           1                     ; Exponent factor for calculating the phase score [-]
G_V           0.20                  ; Weighting factor of the slope score [-]
G_G           0.20                  ; Weighting factor of the magnitude score [-]
G_P           0.20                  ; Weighting factor of the phase score [-]
G_2           0.60                   ; Weighting factor of the cross-correlation method [-] ( NOT USED for ISO_18571 )
#  normalising of the weighting factor ?
WF_NORM       NO                    ; should the Weighting factors be normalized ?
##
## Handhabung der Signale
ISONAME_1-2/11-12   YES YES         ; Beruecksichtigen von Nr.-Testobjekt/Sitzposition (ISO 1-2) sowie vom Dummytyp (ISO 11-12) im ISO-Namen
MIN_NORM            0.00            ; Grenzwert (als Bruchteil des Betragsextremums) fuer die Behandlung sehr kleiner Signale in [0,...,1]
Y_NORM              extremum        ; Berechnungsart/-groesse von Y_NORM (extremum oder Zahl)
##
## Format Ergebnisfiles
OUTPUT_FORMAT LSPOST                ; curve output format (LSPOST, PAMVIEW oder Hypergraph)
##
## Layout html-Report
FONT_SMALL          13              ; small font size in the html report
FONT_LARGE          16              ; large font size in the html report
PreT_LC/PostT_LC   -1  -1           ; enlargement of the shown time intervall (-1: complete curve)
##
## Output
EXPORT_CURVES       YES             ; output of curves 
##
END GLOBAL_PARAMETERS
##
## -----------------------------------------------------------------------------------------------------------------------
## Lokale Parameter (Spezifikation pro Lastfall)
##
##  x = globale Einstellung verwenden
##
BEGIN LOADCASE
METHOD        ISO18571                    ; ISO18571
NAM_LC        Test 1_1                    ; loadcase name
DES_LC        Acceleration 1              ; loadcase description
WF_LC         1                           ; Weighting factor of the loadcase
##
## Layout html-Report
PreT_LC       x                           ; Vorlauf des darzustellenden Zeitverlaufs
PostT_LC      x                           ; Nachlauf des darzustellenden Zeitverlaufs
BEGIN SUBLOADCASE
NAM_SLC        Cae 1                      ; subcase name
DES_SLC        Cae 1                      ; subcase description
WF_SLC         1                          ; Weighting factor of the subcase
BEGIN DATAFILES
## Versuche
## Name              timeshift  unit   g
../data/annex_1_1/annex_a_1_1_test.dat 0.0 m-Kg-s  NO
## Simulation
../data/annex_1_1/annex_a_1_1_cae1.dat 0.0 m-Kg-s  NO
END DATAFILES
##
BEGIN SIGNALS
## Kanaele
##Name            WF  Y_norm  t_min(s)  t_max(s)  g_V  g_G  g_P  g1  g2  a_0  b_0   a_t   a_sigma  b_sigma  D_min  D_max
S1HEAD0000H3ACX0  1   x       0.00160     0.0326   x    x    x    x   x   x    x     NOTSPEC     0        0        x      x
END SIGNALS
END SUBLOADCASE

BEGIN SUBLOADCASE
NAM_SLC        Cae 2                      ; subcase name
DES_SLC        Cae 2                      ; subcase description
WF_SLC         1                          ; Weighting factor of the subcase
BEGIN DATAFILES
## Versuche
## Name              timeshift  unit   g
../data/annex_1_1/annex_a_1_1_test.dat 0.0 m-Kg-s  NO
## Simulation
../data/annex_1_1/annex_a_1_1_cae2.dat 0.0 m-Kg-s  NO
END DATAFILES
##
BEGIN SIGNALS
## Kanaele
##Name            WF  Y_norm  t_min(s)  t_max(s)  g_V  g_G  g_P  g1  g2  a_0  b_0   a_t   a_sigma  b_sigma  D_min  D_max
S1HEAD0000H3ACX0  1   x       0.00160       0.0326        x    x    x    x   x   x    x     NOTSPEC     0        0        x      x
END SIGNALS
END SUBLOADCASE

BEGIN SUBLOADCASE
NAM_SLC        Cae 3                      ; subcase name
DES_SLC        Cae 3                      ; subcase description
WF_SLC         1                          ; Weighting factor of the subcase
BEGIN DATAFILES
## Versuche
## Name              timeshift  unit   g
../data/annex_1_1/annex_a_1_1_test.dat 0.0 m-Kg-s  NO
## Simulation
../data/annex_1_1/annex_a_1_1_cae3.dat 0.0 m-Kg-s  NO
END DATAFILES
##
BEGIN SIGNALS
## Kanaele
##Name            WF  Y_norm  t_min(s)  t_max(s)  g_V  g_G  g_P  g1  g2  a_0  b_0   a_t   a_sigma  b_sigma  D_min  D_max
S1HEAD0000H3ACX0  1   x       0.00160       0.0326         x    x    x    x   x   x    x     NOTSPEC     0        0        x      x
END SIGNALS
END SUBLOADCASE

END LOADCASE
##------------------------------------------------------------------------------
BEGIN LOADCASE
METHOD        ISO18571                    ; ISO18571
NAM_LC        Test 2_2                    ; loadcase name
DES_LC        Angle 1              ; loadcase description
WF_LC         1                           ; Weighting factor of the loadcase
##
## Layout html-Report
PreT_LC       x                           ; Vorlauf des darzustellenden Zeitverlaufs
PostT_LC      x                           ; Nachlauf des darzustellenden Zeitverlaufs
BEGIN SUBLOADCASE
NAM_SLC        Cae 1                      ; subcase name
DES_SLC        Cae 1                      ; subcase description
WF_SLC         1                          ; Weighting factor of the subcase
BEGIN DATAFILES
## Versuche
## Name              timeshift  unit   g
../data/annex_2_2/annex_a_2_2_test.dat 0.0 m-Kg-s  NO
## Simulation
../data/annex_2_2/annex_a_2_2_cae1.dat 0.0 m-Kg-s  NO
END DATAFILES
##
BEGIN SIGNALS
## Kanaele
##Name            WF  Y_norm  t_min(s)  t_max(s)  g_V  g_G  g_P  g1  g2  a_0  b_0   a_t   a_sigma  b_sigma  D_min  D_max
S1HEAD0000H3ANX0  1   x       0.0051     0.1479   x    x    x    x   x   x    x     NOTSPEC     0        0        x      x
END SIGNALS
END SUBLOADCASE

BEGIN SUBLOADCASE
NAM_SLC        Cae 2                      ; subcase name
DES_SLC        Cae 2                      ; subcase description
WF_SLC         1                          ; Weighting factor of the subcase
BEGIN DATAFILES
## Versuche
## Name              timeshift  unit   g
../data/annex_2_2/annex_a_2_2_test.dat 0.0 m-Kg-s  NO
## Simulation
../data/annex_2_2/annex_a_2_2_cae2.dat 0.0 m-Kg-s  NO
END DATAFILES
##
BEGIN SIGNALS
## Kanaele
##Name            WF  Y_norm  t_min(s)  t_max(s)  g_V  g_G  g_P  g1  g2  a_0  b_0   a_t   a_sigma  b_sigma  D_min  D_max
S1HEAD0000H3ANX0  1   x       0.0051     0.0900        x    x    x    x   x   x    x     NOTSPEC     0        0        x      x
END SIGNALS
END SUBLOADCASE

BEGIN SUBLOADCASE
NAM_SLC        Cae 3                      ; subcase name
DES_SLC        Cae 3                      ; subcase description
WF_SLC         1                          ; Weighting factor of the subcase
BEGIN DATAFILES
## Versuche
## Name              timeshift  unit   g
../data/annex_2_2/annex_a_2_2_test.dat 0.0 m-Kg-s  NO
## Simulation
../data/annex_2_2/annex_a_2_2_cae3.dat 0.0 m-Kg-s  NO
END DATAFILES
##
BEGIN SIGNALS
## Kanaele
##Name            WF  Y_norm  t_min(s)  t_max(s)  g_V  g_G  g_P  g1  g2  a_0  b_0   a_t   a_sigma  b_sigma  D_min  D_max
S1HEAD0000H3ANX0  1   x       0.0051     0.1479         x    x    x    x   x   x    x     NOTSPEC     0        0        x      x
END SIGNALS
END SUBLOADCASE
END LOADCASE
#------------------------------------------------------------------------------
BEGIN LOADCASE
METHOD        ISO18571                    ; ISO18571
NAM_LC        Test 3_2                    ; loadcase name
DES_LC        Displacement 2              ; loadcase description
WF_LC         1                           ; Weighting factor of the loadcase
##
## Layout html-Report
PreT_LC       x                           ; Vorlauf des darzustellenden Zeitverlaufs
PostT_LC      x                           ; Nachlauf des darzustellenden Zeitverlaufs
BEGIN SUBLOADCASE
NAM_SLC        Cae 1                      ; subcase name
DES_SLC        Cae 1                      ; subcase description
WF_SLC         1                          ; Weighting factor of the subcase
BEGIN DATAFILES
## Versuche
## Name              timeshift  unit   g
../data/annex_3_2/annex_a_3_2_test.dat 0.0 mm-Kg-s  NO
## Simulation
../data/annex_3_2/annex_a_3_2_cae1.dat 0.0 mm-Kg-s  NO
END DATAFILES
##
BEGIN SIGNALS
## Kanaele
##Name            WF  Y_norm  t_min(s)  t_max(s)  g_V  g_G  g_P  g1  g2  a_0  b_0   a_t   a_sigma  b_sigma  D_min  D_max
S1HEAD0000H3DSX0  1   x       0.010     0.0804   x    x    x    x   x   x    x     NOTSPEC     0        0        x      x
END SIGNALS
END SUBLOADCASE

BEGIN SUBLOADCASE
NAM_SLC        Cae 2                      ; subcase name
DES_SLC        Cae 2                      ; subcase description
WF_SLC         1                          ; Weighting factor of the subcase
BEGIN DATAFILES
## Versuche
## Name              timeshift  unit   g
../data/annex_3_2/annex_a_3_2_test.dat 0.0 mm-Kg-s  NO
## Simulation
../data/annex_3_2/annex_a_3_2_cae2.dat 0.0 mm-Kg-s  NO
END DATAFILES
##
BEGIN SIGNALS
## Kanaele
##Name            WF  Y_norm  t_min(s)  t_max(s)  g_V  g_G  g_P  g1  g2  a_0  b_0   a_t   a_sigma  b_sigma  D_min  D_max
S1HEAD0000H3DSX0  1   x       0.010     0.0804        x    x    x    x   x   x    x     NOTSPEC     0        0        x      x
END SIGNALS
END SUBLOADCASE

BEGIN SUBLOADCASE
NAM_SLC        Cae 3                      ; subcase name
DES_SLC        Cae 3                      ; subcase description
WF_SLC         1                          ; Weighting factor of the subcase
BEGIN DATAFILES
## Versuche
## Name              timeshift  unit   g
../data/annex_3_2/annex_a_3_2_test.dat 0.0 mm-Kg-s  NO
## Simulation
../data/annex_3_2/annex_a_3_2_cae3.dat 0.0 mm-Kg-s  NO
END DATAFILES
##
BEGIN SIGNALS
## Kanaele
##Name            WF  Y_norm  t_min(s)  t_max(s)  g_V  g_G  g_P  g1  g2  a_0  b_0   a_t   a_sigma  b_sigma  D_min  D_max
S1HEAD0000H3DSX0  1   x       0.010     0.0804         x    x    x    x   x   x    x     NOTSPEC     0        0        x      x
END SIGNALS
END SUBLOADCASE
END LOADCASE
##------------------------------------------------------------------------------
BEGIN LOADCASE
METHOD        ISO18571                    ; ISO18571
NAM_LC        Test 4_3                    ; loadcase name
DES_LC        Force 3                     ; loadcase description
WF_LC         1                           ; Weighting factor of the loadcase
##
## Layout html-Report
PreT_LC       x                           ; Vorlauf des darzustellenden Zeitverlaufs
PostT_LC      x                           ; Nachlauf des darzustellenden Zeitverlaufs
BEGIN SUBLOADCASE
NAM_SLC        Cae 1                      ; subcase name
DES_SLC        Cae 1                      ; subcase description
WF_SLC         1                          ; Weighting factor of the subcase
BEGIN DATAFILES
## Versuche
## Name              timeshift  unit   g
../data/annex_4_3/annex_a_4_3_test.dat 0.0 m-Kg-s  NO
## Simulation
../data/annex_4_3/annex_a_4_3_cae1.dat 0.0 m-Kg-s  NO
END DATAFILES
##
BEGIN SIGNALS
## Kanaele
##Name            WF  Y_norm  t_min(s)  t_max(s)  g_V  g_G  g_P  g1  g2  a_0  b_0   a_t   a_sigma  b_sigma  D_min  D_max
S1HEAD0000H3FOX0  1   x       0.0043     0.0909   x    x    x    x   x   x    x     NOTSPEC     0        0        x      x
END SIGNALS
END SUBLOADCASE

BEGIN SUBLOADCASE
NAM_SLC        Cae 2                      ; subcase name
DES_SLC        Cae 2                      ; subcase description
WF_SLC         1                          ; Weighting factor of the subcase
BEGIN DATAFILES
## Versuche
## Name              timeshift  unit   g
../data/annex_4_3/annex_a_4_3_test.dat 0.0 m-Kg-s  NO
## Simulation
../data/annex_4_3/annex_a_4_3_cae2.dat 0.0 m-Kg-s  NO
END DATAFILES
##
BEGIN SIGNALS
## Kanaele
##Name            WF  Y_norm  t_min(s)  t_max(s)  g_V  g_G  g_P  g1  g2  a_0  b_0   a_t   a_sigma  b_sigma  D_min  D_max
S1HEAD0000H3FOX0  1   x       0.0043     0.0909        x    x    x    x   x   x    x     NOTSPEC     0        0        x      x
END SIGNALS
END SUBLOADCASE

BEGIN SUBLOADCASE
NAM_SLC        Cae 3                      ; subcase name
DES_SLC        Cae 3                      ; subcase description
WF_SLC         1                          ; Weighting factor of the subcase
BEGIN DATAFILES
## Versuche
## Name              timeshift  unit   g
../data/annex_4_3/annex_a_4_3_test.dat 0.0 m-Kg-s  NO
## Simulation
../data/annex_4_3/annex_a_4_3_cae3.dat 0.0 m-Kg-s  NO
END DATAFILES
##
BEGIN SIGNALS
## Kanaele
##Name            WF  Y_norm  t_min(s)  t_max(s)  g_V  g_G  g_P  g1  g2  a_0  b_0   a_t   a_sigma  b_sigma  D_min  D_max
S1HEAD0000H3FOX0  1   x       0.0043     0.0909         x    x    x    x   x   x    x     NOTSPEC     0        0        x      x
END SIGNALS
END SUBLOADCASE
END LOADCASE
##------------------------------------------------------------------------------
BEGIN LOADCASE
METHOD        ISO18571                    ; ISO18571
NAM_LC        Test 5_1                    ; loadcase name
DES_LC        Moment 1                    ; loadcase description
WF_LC         1                           ; Weighting factor of the loadcase
##
## Layout html-Report
PreT_LC       x                           ; Vorlauf des darzustellenden Zeitverlaufs
PostT_LC      x                           ; Nachlauf des darzustellenden Zeitverlaufs
BEGIN SUBLOADCASE
NAM_SLC        Cae 1                      ; subcase name
DES_SLC        Cae 1                      ; subcase description
WF_SLC         1                          ; Weighting factor of the subcase
BEGIN DATAFILES
## Versuche
## Name              timeshift  unit   g
../data/annex_5_1/annex_a_5_1_test.dat 0.0 m-Kg-s  NO
## Simulation
../data/annex_5_1/annex_a_5_1_cae1.dat 0.0 m-Kg-s  NO
END DATAFILES
##
BEGIN SIGNALS
## Kanaele
##Name            WF  Y_norm  t_min(ms)  t_max(ms)  g_V  g_G  g_P  g1  g2  a_0  b_0   a_t   a_sigma  b_sigma  D_min  D_max
S1HEAD0000H3MOX0   1   x       0.0073     0.0304   x    x    x    x   x   x    x     NOTSPEC     0        0        x      x
END SIGNALS
END SUBLOADCASE

BEGIN SUBLOADCASE
NAM_SLC        Cae 2                      ; subcase name
DES_SLC        Cae 2                      ; subcase description
WF_SLC         1                          ; Weighting factor of the subcase
BEGIN DATAFILES
## Versuche
## Name              timeshift  unit   g
../data/annex_5_1/annex_a_5_1_test.dat 0.0 m-Kg-s  NO
## Simulation
../data/annex_5_1/annex_a_5_1_cae2.dat 0.0 m-Kg-s  NO
END DATAFILES
##
BEGIN SIGNALS
## Kanaele
##Name            WF  Y_norm  t_min(ms)  t_max(ms)  g_V  g_G  g_P  g1  g2  a_0  b_0   a_t   a_sigma  b_sigma  D_min  D_max
S1HEAD0000H3MOX0   1   x       0.0073     0.0304   x    x    x    x    x   x   x      NOTSPEC     0        0        x      x
END SIGNALS
END SUBLOADCASE

BEGIN SUBLOADCASE
NAM_SLC        Cae 3                      ; subcase name
DES_SLC        Cae 3                      ; subcase description
WF_SLC         1                          ; Weighting factor of the subcase
BEGIN DATAFILES
## Versuche
## Name              timeshift  unit   g
../data/annex_5_1/annex_a_5_1_test.dat 0.0 m-Kg-s  NO
## Simulation
../data/annex_5_1/annex_a_5_1_cae3.dat 0.0 m-Kg-s  NO
END DATAFILES
##
BEGIN SIGNALS
## Kanaele
##Name            WF  Y_norm  t_min(ms)  t_max(ms)  g_V  g_G  g_P  g1  g2  a_0  b_0   a_t   a_sigma  b_sigma  D_min  D_max
S1HEAD0000H3MOX0   1   x       0.0073     0.0304   x        x    x    x    x   x   x     NOTSPEC     0        0        x      x
END SIGNALS
END SUBLOADCASE
END LOADCASE
